<?php
/**
 * Plugin Name: WooCommerce Web Payment Gateway
 * Plugin URI: https://
 * Description: Accept payments on your WooCommerce site in a seamless and secure checkout environment.
 * Version: 2.0.13
 * Author: TESS Payments
 * Author URI: https://tesspayments.com/
 * License: GPL version 2 or later - http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * Text Domain: woocommerce-web-payment-gateway
 *
 * @package WordPress
 * @author TESS Payments
 * @since 1.0.0
 */



/**
 * WPG Main Commerce Class
 */
class WC_WPG {


	/**
	 * Constructor
	 */
	public function __construct() {
		define( 'WC_WPG_VERSION', '2.0.0' );
		define( 'WC_WPG_TEMPLATE_PATH', untrailingslashit( plugin_dir_path( __FILE__ ) ) . '/templates/' );
		define( 'WC_WPG_PLUGIN_URL', untrailingslashit( plugins_url( basename( plugin_dir_path( __FILE__ ) ), basename( __FILE__ ) ) ) );
		define( 'WC_WPG_PLUGIN_DIR', plugins_url( basename( plugin_dir_path( __FILE__ ) ), basename( __FILE__ ) ) . '/' );
		define( 'WC_WPG_MAIN_FILE', __FILE__ );

		// Actions
		add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), array( $this, 'plugin_action_links' ) );
		add_action( 'plugins_loaded', array( $this, 'init' ), 0 );
		add_filter( 'woocommerce_payment_gateways', array( $this, 'register_gateway' ) );
                

	}

	/**
	 * Add info and links to plugin in options
	 * @param  array $links
	 * @return array
	 */
	public function plugin_action_links( $links ) {
		$subscriptions = ( class_exists( 'WC_Subscriptions_Order' ) ) ? '_subscriptions' : '';
		if ( class_exists( 'WC_Subscriptions_Order' ) && ! function_exists( 'wcs_create_renewal_order' ) ) {
			$subscriptions = '_subscriptions_deprecated';
		}
		$plugin_links = array(
			'<a href="' . admin_url( 'admin.php?page=wc-settings&tab=checkout&section=wpgfull' . $subscriptions ) . '">' . __( 'Settings', 'woocommerce-web-payment-gateway' ) . '</a>',

		);
		return array_merge( $plugin_links, $links );
	}

	/**
	 * localisations and files
	 */
	public function init() {

		if ( ! class_exists( 'WC_Payment_Gateway' ) ) {
			return;
		}

		// Includes
		include_once( 'includes/class-wc-web-payment-gateway.php' );

		if ( class_exists( 'WC_Subscriptions_Order' ) ) {
			//include_once( 'includes/class-wc-web-payment-gateway-subscriptions.php' );
		}

		// Localisation
		load_plugin_textdomain( 'woocommerce-web-payment-gateway', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );

	}

	/**
	 * Select the gateway for use
	 */
	public function register_gateway($methods)
	{

		if (
			class_exists('WC_Subscriptions_Order')
		) {
			//$methods[] = 'WC_Web_Payment_Gateway_Subscriptions';
		} else {

			$methods[] = 'WC_Web_Payment_Gateway';
		}

		return $methods;
	}


}


new WC_WPG();
