<?php


if (!defined('ABSPATH')) {
    exit;
}

/**
 * WC_Web_Payment_Gateway class.
 *
 * @since 2.0.0
 * @extends WC_Payment_Gateway
 */
class WC_Web_Payment_Gateway extends WC_Payment_Gateway
{

    private $apimethod = array(
        'checkout' => '/api/v1/session',
        'refund'   => '/api/v1/payment/refund'
    );

    public $debug = 'no';

    public $currencies_3dotexponent = ['USD', 'QAR'];
    public $currencies_noexponent = [
        //'CLP',
        'QAR', 
        'USD', 
        //'ISK', 
        //'UGX', 
        //'KRW', 
        //'JPY'
    ];

    /**
     * Constructor
     */
    public function __construct()
    {
        global $woocommerce;
        // Register plugin information
        $this->id = 'wpgfull';
        $this->has_fields = true;
        $this->supports = array(
            'refunds',
            'products',
            //'subscriptions',
            //'subscription_cancellation',
            //'subscription_suspension',
            //'subscription_reactivation',
            //'subscription_amount_changes',
            //'subscription_date_changes',
            //'subscription_payment_method_change',
            //'subscription_payment_method_change_customer',
            //'subscription_payment_method_change_admin',
        );

        // Create plugin fields and settings
        $this->init_form_fields();
        $this->init_settings();

        // Get setting values
        foreach ($this->settings as $key => $val) {
            $this->$key = $val;
        }



        if (empty($this->icon)) {
            // Load plugin checkout default icon
            $this->icon = WC_WPG_PLUGIN_URL . '/images/default-logo.png';
        }

        
        if ($this->display_icon == 'yes') {
            $this->icon = false;
        }

        //image select
        add_action('admin_enqueue_scripts', array($this, 'loadscripts'));
        add_action('woocommerce_api_wc_set_picture', array($this, 'get_new_image'));


        // Add hooks
        add_action('woocommerce_receipt_wpgfull', array($this, 'receipt_page'));
        //add_action('woocommerce_update_options_payment_gateways', array($this, 'process_admin_options'));
        add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));

        add_action('admin_notices', array($this, 'wpgfull_commerce_ssl_check'));

        // Payment listener/API hook
        add_action('woocommerce_api_wc_web_payment_gateway', array($this, 'check_ipn_response'));
    }


    public function get_new_image()
    {
        if (isset($_GET['id'])) {
            $data = array(
                'image'    => wp_get_attachment_image(filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT), array(90, 20), false, array('id' => 'wpg_custom_logo_prewiev')),
                'imageurl' => wp_get_attachment_image_url(filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT), array(90, 20), true),
            );
            wp_send_json_success($data);
        } else {
            wp_send_json_error();
        }
    }

    function loadscripts($page)
    {
        if ($page == 'woocommerce_page_wc-settings') {
            wp_enqueue_media();
            wp_enqueue_script('wpg_load_logo', WC_WPG_PLUGIN_DIR . 'js/wpg_load_logo.js', array('jquery'));
        }
    }


    /**
     * Refund function for gateway if suppors
     **/

    public function process_refund($order_id, $amount = null, $reason = '')
    {
        $order = wc_get_order($order_id);
        if (!is_a($order, \WC_Order::class)) {
            return false;
        }

        $correct_amount = number_format($amount, 2, '.', '');
        if (in_array(get_woocommerce_currency(), $this->currencies_noexponent)) {
            $correct_amount = number_format($order->get_total(), 0, '.', '');
        }elseif (in_array(get_woocommerce_currency(), $this->currencies_3dotexponent)) {
            $correct_amount = number_format($order->get_total(), 3, '.', '');
        }



        $transaction_id = $order->get_transaction_id();
        $hash = sha1(md5(strtoupper($transaction_id . $correct_amount . $this->password)));
        $main_json = array(
            'merchant_key' => $this->secret,
            'payment_id'    => $transaction_id,
            'amount'      => $correct_amount,
            'hash'         => $hash
        );

        // $options = array(
        //     'http' => array(
        //         'method'  => 'POST',
        //         'content' => json_encode($main_json),
        //         'header' =>  "Content-Type: application/json\r\n"
        //     )
        // );
        
        $action_adr = rtrim($this->url,'/').$this->apimethod['refund'];

        //$action_adr = $this->url.$this->apimethod['refund'];

        $getter = curl_init($action_adr); //init curl
        curl_setopt($getter, CURLOPT_POST, 1); //post
        curl_setopt($getter, CURLOPT_POSTFIELDS, json_encode($main_json)); //json
        curl_setopt($getter, CURLOPT_HTTPHEADER, array('Content-Type:application/json')); //header
        curl_setopt($getter, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($getter);
        $httpcode = curl_getinfo($getter, CURLINFO_HTTP_CODE);

        //$context  = stream_context_create($options);
        //$result = file_get_contents($action_adr, false, $context);

        if ('yes' == $this->debug) {
            $log = new WC_Logger();
            $log->add('wpgLog', 'RefundResponse: ' . $httpcode . $result);
        }
        if ($httpcode != 200) {
            return false;
        }
        $response = json_decode($result, true);
        if ($response['result'] == 'accepted' && $response['payment_id'] == $transaction_id) {
            return true;
        }

        return false;
    }

    function check_ipn_response()
    {
        global $woocommerce;
        if ('yes' == $this->debug) {
            $log = new WC_Logger();
            $log->add('wpgLog', 'POST api: ' . print_r($_POST, true));
            $log->add('wpgLog', 'GET api: ' . print_r($_GET, true));
        }

        if ($_SERVER['REQUEST_METHOD'] != 'POST') {
            exit;
        }

        $hash_string = $_POST['id'] . $_POST['order_number'] . $_POST['order_amount'] . $_POST['order_currency'] . $_POST['order_description'] . $this->password;
        $hash = sha1(md5(strtoupper($hash_string)));

        if ($_POST['hash'] != $hash) {
            //error_log("hash invalid");
            exit;
        }

        $order_id = $_POST['order_number'];
        $order = new WC_Order($order_id);
        $order->set_transaction_id($_POST['id']);

        if ($order->get_status() == 'pending' || $order->get_status() == 'waiting' || $order->get_status() == 'failed' || $order->get_status() == '') {

            if ($_POST['status'] == 'success' && $_POST['type'] == 'sale') {
                //successful purchase
                $woocommerce->cart->empty_cart();
                $order->update_status('completed', 'Payment successfully paid'); //completed or processing
                //$order->payment_complete($_POST['id']);
                exit;
            }

            if ($_POST['status'] == 'waiting' && $_POST['type'] == 'sale') {
                //waiting purchase
                //error_log('status fail sale');
                $order->update_status('on-hold', __('On hold', 'woocommerce'));
                exit;
            }

            if ($_POST['status'] == 'fail' && $_POST['type'] == 'sale') {
                //failed purchase
                //error_log('status fail sale');
                $order->update_status('failed', $_POST['reason']);
                exit;
            }
        }

        if ($order->get_status() == 'completed' || $order->get_status() == 'processing') {
            if ($_POST['status'] == 'success' && $_POST['type'] == 'refund') {
                //$order->update_status('refunded', __('Refunded', 'woocommerce'));
                $order->add_order_note('Refund confirmed by the payment system');
                exit;
            }
            if ($_POST['status'] == 'fail' && $_POST['type'] == 'refund') {
                $order->update_status('failed', $_POST['reason']);
                exit;
            }
        }
    }


    /**
     * Check if SSL is enabled and notify the user.
     */
    function wpgfull_commerce_ssl_check()
    {
        //if (!$_POST)
        //if ('no' == get_option('woocommerce_force_ssl_checkout') && 'yes' == $this->enabled) {
        if (is_ssl() == false && 'yes' == $this->enabled) {
            $admin_url = admin_url('admin.php?page=wc-settings&tab=checkout');
            echo '<div class="notice notice-error is-dismissible"><p>' . sprintf(__('TESS Payments GW is enabled. But <a href="%s">force SSL option</a> is disabled. Your checkout is not secure! Please enable SSL and ensure your server has a valid SSL certificate.', 'woocommerce-gateway-wpgfull'), $admin_url) . '</p></div>';
        }
    }

    /**
     * Initialize Gateway Settings Form Fields.
     */
    function init_form_fields()
    {

        $this->form_fields = array(
            'enabled' => array(
                'title' => __('Enable/Disable', 'woocommerce-gateway-wpgfull'),
                'label' => __('Enable TESS Payments GW Commerce', 'woocommerce-gateway-wpgfull'),
                'type' => 'checkbox',
                'description' => '',
                'default' => 'no',
            ),
            'title' => array(
                'title' => __('Title', 'woocommerce-gateway-wpgfull'),
                'type' => 'text',
                'description' => __('This controls the title which the user sees during checkout.', 'woocommerce-gateway-wpgfull'),
                'default' => __('TESS Payments GW Commerce', 'woocommerce-gateway-wpgfull'),
                'desc_tip' => true,
            ),
            'description' => array(
                'title' => __('Front description', 'woocommerce-gateway-wpgfull'),
                'type' => 'text',
                'default' => __('Pay online through TESS Payments GW Commerce', 'woocommerce-gateway-wpgfull'),
            ),
            'method_description' => array(
                'title' => __('Description', 'woocommerce-gateway-wpgfull'),
                'type' => 'textarea',
                'description' => __('TESS Payments GW redirects customers enter payment details.', 'woocommerce-gateway-wpgfull'),
                'default' => __('You can make a payment through the Web Payment Gateway system', 'woocommerce'),
            ),
            'url' => array(
                'title' => __('Checkout host', 'woocommerce-gateway-wpgfull'),
                'type' => 'text',
                'description' => __('Url from payment system to send a payment request', 'woocommerce-gateway-wpgfull'),
            ),
            // 'refundurl' => array(
            //     'title' => __('Refund Link', 'woocommerce-gateway-wpgfull'),
            //     'type' => 'text',
            //     'description' => __('Url from payment system to send a refund request', 'woocommerce-gateway-wpgfull'),
            // ),
            'method' => array(
                'title' => __('Payment method', 'woocommerce-gateway-wpgfull'),
                'type' => 'multiselect',
                'description' => __('Payment method that client uses', 'woocommerce-gateway-wpgfull'), /////
                'options' => array(
                    'card' => 'Credit Card',
                    'naps' => 'NAPS Debit Card'
                ),
            ),
            'secret' => array(
                'title' => __('Merchant key', 'woocommerce-gateway-wpgfull'),
                'type' => 'text',
                'description' => __('Merchant key from payment system for customer identification', 'woocommerce-gateway-wpgfull'),
            ),
            'password' => array(
                'title' => __('Merchant password', 'woocommerce-gateway-wpgfull'),
                'type' => 'text',
                'description' => __('Merchant password from payment system.', 'woocommerce-gateway-wpgfull'),
            ),
            'debug' => array(
                'title' => __('Enable debug', 'woocommerce-gateway-wpgfull'),
                'type' => 'text',
                'default' => 'no',
                'description' => __('Enable debug logs', 'woocommerce-gateway-wpgfull'),
            ),
            'display_icon' => array(
                'title' => __('Hide icon on front', 'woocommerce-gateway-wpgfull'),
                'type' => 'checkbox'
            ),
            'icon' => array(
                //   'title' => __('Logo Url', 'woocommerce-gateway-wpgfull'),
                'type' => 'hidden',
                //  'description' => __('Logo that is displayed to customers', 'woocommerce-gateway-wpgfull'),
                'class' => 'wpg_custom_logo',
            ),
        );
    }

    /**
     * UI - Admin Panel Options
     */
    function admin_options()
    {

?>
        <h3><?php _e('Web Payment Gateway Settings', 'woocommerce-gateway-wpgfull'); ?></h3>
        <p><?php _e('Web Payment Gateway. The plugin works by opened checkout page, and then sending the details to payment system for verification.', 'woocommerce-gateway-wpgfull'); ?></p>
        <input type="hidden" name="" id="wc_api_url" value="<?php echo add_query_arg('wc-api', 'wc_set_picture', home_url('/')); ?>">
        <table class="form-table">
            <?php
            $this->generate_settings_html();
            ?>
            <p>
                <strong><?php _e('Callback Url: ') ?></strong><?php echo add_query_arg('wc-api', 'wc_web_payment_gateway', home_url('/')); ?>
            </p>
            <!--  -->
            <tr valign="top" class="">
                <th scope="row" class="titledesc">
                    <label for="myprefix_media_manager">Logo </label>
                </th>
                <td class="forminp">
                    <fieldset>
                        <legend class="screen-reader-text"><span>Preview</span></legend>
                        <img id="wpg_custom_logo_prewiev" width="90" height="20" src="<?= $this->icon ?>" alt="<?= $this->title ?>">
                        <input type='button' class="button-primary" value="<?php esc_attr_e('Select a image', 'mytextdomain'); ?>" id="myprefix_media_manager" />
                        <p class="description">Custom logo payment system.</p>
                    </fieldset>
                </td>
            </tr>
            <!--  -->
        </table>


<?php
    }



    /**
     * Process the payment and return the result.
     *
     * @param int @order_id
     * @return array
     */
    public function process_payment($order_id)
    {

        $order = new WC_Order($order_id);
        $user = new WP_User($order->get_user_id());
        //get_checkout_payment_url() or WC_Order::get_checkout_order_received_url()

        // return array(
        //     'result' => 'success',
        //     'redirect' => add_query_arg('order', $order->id, add_query_arg('key', $order->get_order_key(), get_permalink(woocommerce_get_page_id('pay'))))
        // );
        return array(
            'result' => 'success',
            'redirect' => $this->get_transaction_url($order)
        );
    }





    /**
     * Display information on the Thank You page
     *
     * @param $order
     */
    function receipt_page($order)
    {
        $ord = new WC_Order($order);
        $form = $this->generate_form($order);
        if ($form === false) {
            echo ('</a> <a class="button cancel" href="' . $ord->get_cancel_order_url() . '">' . __('Payment gateway error', 'woocommerce') . '</a>' . "\n");
        } else {
            echo '<p>' . __('Thank you for your order.', 'woocommerce-gateway-wpgfull') . '</p>';
            echo $form;
        }
    }

    public function generate_form($order_id, bool $returnurl = false)
    {
        global $woocommerce;

        $order = new WC_Order($order_id);

        $action_adr = rtrim($this->url,'/').$this->apimethod['checkout'];
        //$action_adr = $this->url.$this->apimethod['checkout'];
        if ('yes' == $this->debug) {
            $log = new WC_Logger();
            $log->add('wpgLog', 'CheckoutGetUrl: ' .$action_adr);
        }

        //$result_url = str_replace('https:', 'http:', add_query_arg('wc-api', 'wc_web_payment_gateway', home_url('/')));


        $customer = array(
            'name' => $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(),
            'email' => $order->get_billing_email(),
        );
        $billing_address = array(
            'country' => $order->get_billing_country() ? $order->get_billing_country() : 'NA',
            'state' => $order->get_billing_state() ? $order->get_billing_state() : 'NA',
            'city' => $order->get_billing_city() ? $order->get_billing_city() : 'NA',
            'address' => $order->get_billing_address_1() ? $order->get_billing_address_1() : 'NA',
            'zip' => $order->get_billing_postcode() ? $order->get_billing_postcode() : 'NA',
            'phone' => $order->get_billing_phone() ? $order->get_billing_phone() : 'NA',
        );

        $amount = number_format($order->get_total(), 2, '.', '');
        if (in_array(get_woocommerce_currency(), $this->currencies_noexponent)) {
            $amount = number_format($order->get_total(), 0, '.', '');
        }elseif (in_array(get_woocommerce_currency(), $this->currencies_3dotexponent)) {
            $amount = number_format($order->get_total(), 3, '.', '');
        }


        $order_json = array(
            'number' => "$order_id",
            'description' => __('Payment Order # ', 'woocommerce') . $order_id . __(' in the store ', 'woocommerce') . home_url('/'),
            'amount' => $amount, //may troubles
            'currency' => get_woocommerce_currency(),
        );

        

        $methods = $this->method; //may error
        //error_log("lg".var_export($methods,true));
        if($methods == null){
            $methods = array();
        }

        $str_to_hash = $order_id . $amount . get_woocommerce_currency() . __('Payment Order # ', 'woocommerce') . $order_id . __(' in the store ', 'woocommerce') . home_url('/') . $this->password;
        $hash = sha1(md5(strtoupper($str_to_hash)));

        $main_json = array(
            'merchant_key' => $this->secret,
            'operation'    => 'purchase', //m subs purchase
            'methods'      => $methods,
            'order'        => $order_json,
            'customer'     => $customer,
            'billing_address' => $billing_address,
            'success_url' => $this->get_return_url($order),
            'cancel_url'   => $order->get_view_order_url(), //
            'hash'         => $hash
        );



        $getter = curl_init($action_adr); //init curl
        curl_setopt($getter, CURLOPT_POST, 1); //post
        curl_setopt($getter, CURLOPT_POSTFIELDS, json_encode($main_json)); //json
        curl_setopt($getter, CURLOPT_HTTPHEADER, array('Content-Type:application/json')); //header
        curl_setopt($getter, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($getter);
        $httpcode = curl_getinfo($getter, CURLINFO_HTTP_CODE);

        if ('yes' == $this->debug) {
            $log = new WC_Logger();
            $log->add('wpgLog', 'CheckoutGet: ' .json_encode($main_json));
            error_log($httpcode . $result);
        }

        if ($httpcode != 200) {
            if ('yes' == $this->debug) {
                $log = new WC_Logger();
                $log->add('wpgLog', 'CheckoutResponse: ' . $httpcode . ' ' . $result);
                error_log($httpcode . $result);
            }
            return false;
        }
        $response = json_decode($result, true);
        if ($returnurl === true) {
            return $response['redirect_url'];
        }

        return
            '<a class="button alt" href="' . $response['redirect_url'] . '">' . __('Pay', 'woocommerce') . '</a> <a class="button cancel" href="' . $order->get_cancel_order_url() . '">' . __('Refuse payment & return to cart', 'woocommerce') . '</a>' . "\n";
    }

    public function get_transaction_url($order)
    {

        return $this->generate_form($order->get_id(), true) ? $this->generate_form($order->get_id(), true) : '';
    }
}
